//===============================================================================================
// Object:        PreInterview and helper methods
//
// Description:   Support the gathering of customer PreInterviewFeedback on help and its related context.
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================
 var selected = null;
 var selName = null;
 var gDefaultID = null;
 var gDefaultFilename = null;
 var gbFilesFound = null;
 var gOverviewWindow = null;

var currentFocusItem = "";
var gFsid = "";

function main()
{
   // disable accelarators 
   document.onkeydown = _preInterview_disableAccelerators;
   document.ondragstart = _preInterview_disableDrag; // disable drag drop
   // take the body out of the tab order
   if( document.body) document.body.tabIndex = -1;
   // make linkes blue
   document.vlinkColor = "#0000ff";


   setFocus();
}

//-----------------------------------------------------------------------------
function _preInterview_disableAccelerators()
{
   try
   {
      var evt=window.event;
      if(!evt)return;
      
      var bCancel = false;
      var tag, btn;
      
      // Disable carriage return except in textareas (don't support select)
      // and links...which sends a mouse click event
      if( 13==evt.keyCode )
      {
         bCancel = true;
         if( evt.srcElement && evt.srcElement.tagName )
         {     
            tag = evt.srcElement.tagName.toLowerCase();
            if( "textarea" == tag ) bCancel = false;
            else if( "a" == tag )
            {
               if( evt.srcElement.onclick ) evt.srcElement.fireEvent( "onclick" );
               else bCancel = false;
            }  
            else if( "select" == tag ) bCancel = false;
            else if( "input" == tag && "button" == evt.srcElement.type ) bCancel = false;
         }
      }  
      // Disable backspace except in textareas and input text boxes
      else if( 8==evt.keyCode )
      {
         bCancel = true;
         if( evt.srcElement && evt.srcElement.tagName )
         {
            tag = evt.srcElement.tagName.toLowerCase();
            if( "input" == tag )
            {
               var tp=evt.srcElement.type;
               if( "text"==tp || "password"==tp ) bCancel = false; 
            }
            else if( "textarea" == tag ) bCancel = false;
         }  
      }
      // Space key on links and buttons behaves like the enter key
      else if( 32 == evt.keyCode )
      {
         if( evt.srcElement && evt.srcElement.tagName )
         {
            tag = evt.srcElement.tagName.toLowerCase();
            if( "a" == tag )
            {
               if( evt.srcElement.onclick ) evt.srcElement.fireEvent( "onclick" );
               else evt.keyCode = 13;
            }  
            else if( "input" == tag && "button" == evt.srcElement.type ) evt.keyCode = 13;
         }     
      }  
      
      if( bCancel )
      {
         evt.cancelBubble = true;
         evt.returnValue = false;
      }
   } catch (exc) {}
}

//-----------------------------------------------------------------------------
function _preInterview_disableDrag()
{
   try
   {
      var evt=window.event;
      if(!evt)return;

      evt.cancelBubble = true;
      evt.returnValue = false;
   } catch (exc) {}
}
 
function selrow(id)
{
   try
   {
      var element = document.getElementById( id );
      if (element)
      {
         selected = element;
         selName = element.fullname;
      }
   }
   catch (element) {}
}

// call cpp code to get the data to populate the list box with
function fillExistingReturnListBox(hiddenid,listid)
{
   try
   {
      currentFocusItem = "";
      var hiddenelem = document.getElementById(hiddenid);
      var elem = document.getElementById(listid);
      if (hiddenelem && elem)
      {
         hiddenelem.fireEvent("onclick");
         var str = hiddenelem.title;
         var strHTML = '';
         if ((hiddenid == "CreateFileListNoStatusAmend")  || (hiddenid == "CreateFileListNoStatusExtend"))
            strHTML = addTableHeaderNoStatus(hiddenid);
         else
            strHTML = addTableHeaderWithStatus();

         // if "No Files Found" in str
         var pattern = /No Files Found/;
         if (pattern.exec(str))
            gbFilesFound = "0";
         else
            gbFilesFound = "1";

         str = eval(str);
         strHTML += str;
         
         if ((hiddenid == "CreateFileListNoStatusAmend") || (hiddenid == "CreateFileListNoStatusExtend"))
            strHTML += addTableFooterNoStatus(hiddenid);
         else
            strHTML += addTableFooterWithStatus();
         
         elem.innerHTML = strHTML;
         selrow(gDefaultID);
      }
   }
   catch(hiddenelem){};
}
// create header
function addTableHeaderWithStatus()
{
   var htmlstr = '';
   try
   {
          htmlstr +=  '<TABLE id="ExistingReturnTable" cellSpacing="0" cellPadding="0" width="100%" border="0">';
         htmlstr +=  '<TR>';
         htmlstr +=  '<div style="WIDTH: 560px;">';
         htmlstr +=  '<div style="FONT-WEIGHT: bold; FONT-SIZE: 14px; COLOR: #777777; BACKGROUND-COLOR: white" id="DIV1">';
         htmlstr +=  '<span style="WIDTH: 20px"></span>'; 
         htmlstr +=  '<span style="WIDTH:260px">File Name</span>';
         htmlstr +=  '<span style="WIDTH:172px">Status</span>';
         htmlstr +=  '<span style="WIDTH:100px">Last Modified</span>';
         htmlstr +=  '</div>';
         htmlstr +=  '</div>';
         htmlstr +=  '<div style="WIDTH: 560px; border-top: 1px solid;">';

   }
   catch(htmlstr){};
   return htmlstr;
}


function DoSuperButton( containerId,
                  buttonId,
                  buttonText,
                  tabIndex, 
                  hasLeftArrow, 
                  hasRightArrow, 
                  isEnabled)
{
   var htmlstr = '';
   var tableDataEnabledStr = '<td class="superButtons" style="cursor:hand;">';
   var tableDataDisabledStr = '<td class="superButtons">';
   try
   {
      var containerElement = document.getElementById(containerId);
      if (!containerElement)
      {
         alert("Cannot find container element for button: " + buttonText);
         return;
      }
      
      /*htmlstr += MakeSuperButtonSpan(   buttonId,
                              buttonText,
                              tabIndex, 
                              hasLeftArrow, 
                              hasRightArrow, 
                              isEnabled);*/
      htmlstr += MakeSuperButton(   buttonId,
                              buttonText,
                              tabIndex, 
                              hasLeftArrow, 
                              hasRightArrow, 
                              isEnabled);
      //alert(htmlstr);
      containerElement.innerHTML = htmlstr;
   }
   catch (htmlstr) { alert(htmlstr); };
}

function DoSuperMouseClickGraphics( buttonContainer, hasLeftArrow, hasRightArrow )
{
   var errorstr='';
   var currentChild=null;
   var imgChild=null;
   try
   {
      // buttonContainer should be the span
      if (buttonContainer) // the container is a table
      {
      //alert(buttonContainer.innerHTML);
         if (buttonContainer.hasChildNodes())
         {
            // down to <tr>
            currentChild = buttonContainer.firstChild;
            if (currentChild.hasChildNodes())
            {  // down to <td>
               currentChild = currentChild.firstChild;
               if (currentChild.hasChildNodes())
               {  // down to <td>
                  currentChild = currentChild.firstChild;
                  if (currentChild.hasChildNodes())
                  {  // down to <img>
                     imgChild = currentChild.firstChild;
                     imgChild.setAttribute("src","../img/md_left_blu_click.gif");
                  }
                  currentChild = currentChild.nextSibling;
                  if (hasLeftArrow == true)
                  {
                     if (currentChild.hasChildNodes())
                     {  // down to <img>
                        imgChild = currentChild.firstChild;
                        imgChild.setAttribute("src","../img/mdicn_arrowblu_left_click.gif");
                     }
                     currentChild = currentChild.nextSibling;
                  }
                  
                  currentChild.style.backgroundImage = 'url("../img/md_bkgrd_blu_click.gif")';
                  currentChild = currentChild.nextSibling;
                  
                  if (hasRightArrow == true)
                  {
                     if (currentChild.hasChildNodes())
                     {  // down to <img>
                        imgChild = currentChild.firstChild;
                        imgChild.setAttribute("src","../img/mdicn_arrowblu_right_click.gif");
                     }
                     currentChild = currentChild.nextSibling;
                  }
                  
                  if (currentChild.hasChildNodes())
                  {  // down to <img>
                     imgChild = currentChild.firstChild;
                     imgChild.setAttribute("src","../img/md_right_blu_click.gif");
                  }
               }
            }
         }
      }
   }
   catch(errorstr) {};
}

function DoSuperMouseDown( buttonContainer, hasLeftArrow, hasRightArrow )
{
   var errorstr='';
   var currentChild=null;
   try
   {
      // buttonContainer should be the span
      if (buttonContainer) 
      {
      //alert(buttonContainer.innerHTML);
         buttonContainer.style.backgroundImage = 'url("../img/md_bkgrd_blu_click.gif")';
         // the first child should be the left side image.
         if (buttonContainer.hasChildNodes())
         {
            // the left side image.
            currentChild = buttonContainer.firstChild;
            currentChild.setAttribute("src","../img/md_left_blu_click.gif");
            if (hasLeftArrow == true)
            {
               currentChild = currentChild.nextSibling;
               currentChild.setAttribute("src","../img/mdicn_arrowblu_left_click.gif");
            }
            // skip the text child? 
            currentChild = currentChild.nextSibling;
            //currentChild.style.backgroundImage = 'url("../img/md_bkgrd_blu_click.gif")';
                     
            if (hasRightArrow == true)
            {
               currentChild = currentChild.nextSibling;
               currentChild.setAttribute("src","../img/mdicn_arrowblu_right_click.gif");
               // set the child up for the right side...
            }
            
            currentChild = currentChild.nextSibling;
            currentChild.setAttribute("src","../img/md_right_blu_click.gif");
         }
      }
   }
   catch(errorstr) {};
}

function MakeSuperButtonSpan(buttonId,
                        buttonText,
                        tabIndex, 
                        hasLeftArrow, 
                        hasRightArrow, 
                        isEnabled)
{
   var htmlstr = '';
   try
   {
      htmlstr += '<span id="' + buttonId + '" tabIndex="' + tabIndex + '" onkeyup="preInterview_accelarator(this)" style="margin:0px;border:none;padding:0px;vertical-align:middle;">';
      htmlstr += '<table cellpadding=0px cellspacing=0px><tr style="margin:0px;border:none;padding:0px;vertical-align:middle;"><td>'
      htmlstr += '<span class="superButtons" style="vertical-align:middle;"';
      if (isEnabled)
      {
         htmlstr += 'onclick="' + buttonId + '.click()' + '" ';
         htmlstr += 'style="BACKGROUND-IMAGE:url(../img/md_bkgrd_blu.gif);CURSOR:hand"';
         htmlstr += 'onmousedown="DoSuperMouseDown( this, ' + hasLeftArrow + ',' + hasRightArrow + ')">';
      }
      else
         htmlstr += 'style="BACKGROUND-IMAGE:url(../img/md_bkgrd_blu_dis.gif);>';
         
      htmlstr += '<img style="vertical-align:middle;" ';
      if (isEnabled)
         htmlstr += 'src="../img/md_left_blu.gif">';
      else
         htmlstr += 'src="../img/md_left_blu_dis.gif">';
         
      if (hasLeftArrow)
      {
         htmlstr += '<img style="vertical-align:middle;" ';
         if (isEnabled)
            htmlstr += 'src="../img/mdicn_arrowblu_left.gif">';
         else
            htmlstr += 'src="../img/mdicn_arrowblu_left_dis.gif">';
      }
      
      // write out the button text.
      htmlstr += buttonText;  

      // Do the Right arrow if there is one
      if (hasRightArrow)
      {
         htmlstr += '<img style="vertical-align:middle;" ';
         if (isEnabled)
            htmlstr += 'src="../img/mdicn_arrowblu_right.gif">';
         else
            htmlstr += 'src="../img/mdicn_arrowblu_right_dis.gif">';
      }
      
      htmlstr += '<img style="vertical-align:middle;" ';
      if (isEnabled)
         htmlstr += 'src="../img/md_right_blu.gif"></span>';
      else
         htmlstr += 'src="../img/md_right_blu_dis.gif"></span>';
         
      htmlstr += '</td></tr></table></span>';
      
   }
   catch(htmlstr){ return htmlstr; };
   return htmlstr;
}

function MakeSuperButton(buttonId,
                  buttonText,
                  tabIndex, 
                  hasLeftArrow, 
                  hasRightArrow, 
                  isEnabled)
{
   var htmlstr = '';
   var tableDataEnabledStr = '<td class="superButtons" style="cursor:hand;">';
   var tableDataDisabledStr = '<td class="superButtons">';
   try
   {
      htmlstr += '<table cellpadding=0px cellspacing=0px id="' + buttonId + 'Table"';

      if (isEnabled)
      {
         htmlstr += 'tabIndex="' + tabIndex + '" onclick="' + buttonId + '.click()" ';
         htmlstr += 'onkeyup="preInterview_accelarator(this)" ';
         htmlstr += 'onmousedown="DoSuperMouseClickGraphics( this, ' + hasLeftArrow + ',' + hasRightArrow + ')">';
      }
      else
         htmlstr += '>';
      htmlstr += '<tr style="margin:0px;padding:0px;border:none; vertical-align:middle">';
      // 
      // Do the left side of the button
      if (isEnabled)
         htmlstr += tableDataEnabledStr;
      else
         htmlstr += tableDataDisabledStr;
      htmlstr += '<img id="' + buttonId + '" style="vertical-align:bottom;"';
      if (isEnabled == false)
         htmlstr += ' src="../img/md_left_blu_dis.gif">';
      else
         htmlstr += ' src="../img/md_left_blu.gif">';
         
      htmlstr += '</td>';
      // If the button has a left arrow (like the Back button), do the left arrow
      if (hasLeftArrow)
      {
         if (isEnabled)
            htmlstr += tableDataEnabledStr;
         else
            htmlstr += tableDataDisabledStr;
         htmlstr += '<img style="vertical-align:bottom;"';
         if (isEnabled == false)
            htmlstr += ' src="../img/mdicn_arrowblu_left_dis.gif">';
         else
            htmlstr += ' src="../img/mdicn_arrowblu_left.gif">';
         htmlstr += '</td>';
      }

      
      // Do the center with the background and text.
      htmlstr += '<td class="superButtons" ';
      if (isEnabled)
      {
         htmlstr += 'style="background-image:url(../img/md_bkgrd_blu.gif);';
         htmlstr += ' cursor:hand;">';
      }
      else
         htmlstr += 'style="background-image:url(../img/md_bkgrd_blu_dis.gif);">';
         
      htmlstr += buttonText;  
      
      htmlstr += '</td>';
      
      // Do the Right arrow if there is one
      if (hasRightArrow)
      {
         if (isEnabled)
            htmlstr += tableDataEnabledStr;
         else
            htmlstr += tableDataDisabledStr;
         
         htmlstr += '<img style="vertical-align:bottom;"';
         if (isEnabled == false)
            htmlstr += ' src="../img/mdicn_arrowblu_right_dis.gif">';
         else
            htmlstr += ' src="../img/mdicn_arrowblu_right.gif">';
         htmlstr += '</td>';
      }
      
      // Do the right side.
      if (isEnabled)
         htmlstr += tableDataEnabledStr;
      else
         htmlstr += tableDataDisabledStr;
      
      htmlstr += '<img style="vertical-align:bottom"';
      if (isEnabled == false)
         htmlstr += ' src="../img/md_right_blu_dis.gif">';
      else
         htmlstr += ' src="../img/md_right_blu.gif">';
      
      htmlstr += '</td>';     

      htmlstr += '</tr></table>';
      
   }
   catch(htmlstr){ return htmlstr; };
   
   return htmlstr;

}

// create header
function addTableFooterWithStatus()
{
   var htmlstr = '';
   try
   {
      htmlstr += '</div>';
      htmlstr += '<table cellpadding=0px cellspacing=0px width="100%"><tr><td align="right">';
      htmlstr += '<div class="normalTopPadding" style="text-align:right;" align="right">';
      htmlstr += '<span id="ExistingBtn">';
      htmlstr += '<table id="ExistingBtnTable" cellpadding="0px" cellspacing="0px" ';
      if (gbFilesFound == "0") // no files found
      {
         htmlstr += '><tr style="margin:0px;padding:0px;border:none; vertical-align:middle">';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/md_left_blu_dis.gif"></td>';
         htmlstr += '<td class="superbuttons" style="BACKGROUND-IMAGE:url(../img/md_bkgrd_blu_dis.gif);">Continue Return</td>';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/mdicn_arrowblu_right_dis.gif"></td>';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/md_right_blu_dis.gif"></td>';
         setFocusItemID("NewBtn");
      }
      else
      {
         htmlstr += ' onmousedown="DoSuperMouseClickGraphics( this, false, true )" ';
         htmlstr += ' onkeyup="preInterview_accelarator(this)" tabIndex="2" ';
         htmlstr += 'onclick="OnContinueReturn(selName,';
         htmlstr +=                                    "'ExistingBtn');";
         htmlstr +=                            '">';
         htmlstr += '<tr style="margin:0px;padding:0px;border:none; vertical-align:middle"><td>';
         htmlstr += '<img style="vertical-align:bottom;" src="../img/md_left_blu.gif"></td>';
         htmlstr += '<td class="superbuttons" style="background-image:url(../img/md_bkgrd_blu.gif); CURSOR:hand;">Continue Return</td>';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/mdicn_arrowblu_right.gif"></td>';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/md_right_blu.gif"></td>';
         setFocusItemID("ExistingBtnTable");
      }
      htmlstr += '</tr></table>';
      htmlstr += '</span>';
      

      htmlstr += '</div></td></tr></table>';
      htmlstr += '<br/>';
      htmlstr += '<div class="normalTopPadding" style="text-align: right;">';
      htmlstr += '<span class="ds_stylemain" id="BrowseBtn"/><span tabIndex = "6" onclick="generateClick(';
      htmlstr += "'BrowseBtn')";
        htmlstr += '" onkeyup="preInterview_accelarator(this)"';
      htmlstr += 'style="text-decoration: underline; COLOR: #3300ff;CURSOR: hand; FONT-SIZE: 14px"><br>';
      htmlstr += 'Browse to find file</span><br/><br/>';
      htmlstr += '</div>';
   }
   catch(htmlstr){};
   return htmlstr;
}

// create header
function addTableHeaderNoStatus(hiddenid)
{
   var htmlstr = '';
   try
   {
         if (hiddenid == "CreateFileListNoStatusAmend")
            htmlstr  +=  '<TABLE id="AmendingReturnTable" cellSpacing="0" cellPadding="0" width="100%" border="0">';
         else
            htmlstr  +=  '<TABLE id="ExistingReturnTable" cellSpacing="0" cellPadding="0" width="100%" border="0">';    
         htmlstr +=  '<TR>';
         htmlstr +=  '<div style="WIDTH: 560px">';
         htmlstr +=  '<div style="FONT-WEIGHT: bold; FONT-SIZE: 14px; COLOR: #777777; BACKGROUND-COLOR: white" id="DIV2">';
         htmlstr +=  '<span style="WIDTH: 20px"></span>'; // leave room for radio button
         htmlstr +=  '<span style="WIDTH:440px">File Name</span>';
         htmlstr +=  '<span style="WIDTH:100px">Last Modified</span>';
         htmlstr +=  '</div>';
         htmlstr +=  '</div>';
         htmlstr +=  '<div style="WIDTH: 560px; border-top: 1px solid;">';

   }
   catch(htmlstr){};
   return htmlstr;
}

// create header
function addTableFooterNoStatus(hiddenid)
{
   var htmlstr = '';
   try
   {
      htmlstr = '</div>';
      htmlstr += '<div class="normalTopPadding" style="text-align: right;">';
      
      htmlstr += '<table cellpadding=0px cellspacing=0px width="100%"><tr><td align="right">';
      htmlstr += '<div class="normalTopPadding" style="text-align:right;" align="right">';
      
      if (hiddenid == "CreateFileListNoStatusAmend")
      {
         htmlstr += '<span id="AmendExistingBtn" align="right">';
         htmlstr += '<table id="AmendExistingBtnTable" cellpadding="0px" cellspacing="0px" ';
      }
      else
      {
         htmlstr += '<span id="ExtendExistingBtn" align="right">';
         htmlstr += '<table id="ExtendExistingBtnTable" cellpadding="0px" cellspacing="0px" ';
      }
      
      
      
      if (gbFilesFound == "0") // no files found
      {
         htmlstr += '>';
         htmlstr += '<tr style="margin:0px;padding:0px;border:none; vertical-align:middle">';
         htmlstr += '<td><img style="vertical-align:middle;" src="../img/md_left_blu_dis.gif"></td>';
         htmlstr += '<td class="superbuttons" style="BACKGROUND-IMAGE:url(../img/md_bkgrd_blu_dis.gif);">';
         if (hiddenid == "CreateFileListNoStatusAmend")
         {
            htmlstr += 'Amend Selected Return';
         }
         else
         {
            htmlstr += 'Extend Existing Return';
         }
         htmlstr += '</td>';
         htmlstr += '<td><img style="vertical-align:middle;" src="../img/mdicn_arrowblu_right_dis.gif"></td>';
         htmlstr += '<td><img style="vertical-align:middle;" src="../img/md_right_blu_dis.gif"></td>';
         htmlstr += '</tr></table>';
         htmlstr += '</span>';
         setFocusItemID("FocusNewID");
      }
      else
      {
         htmlstr += ' onmousedown="DoSuperMouseClickGraphics( this, false, true )" ';
         htmlstr += ' onkeyup="preInterview_accelarator(this)" tabIndex="3" ';
         htmlstr += 'onclick="OnContinueReturn(selName,';
         if (hiddenid == "CreateFileListNoStatusAmend")
         {
            htmlstr +=                      "'AmendExistingBtn');";
         }
         else
         {
            htmlstr +=                      "'ExtendExistingBtn');";
         }
         htmlstr +=                            '">';
         htmlstr += '<tr style="margin:0px;padding:0px;border:none; vertical-align:middle">';
         //htmlstr += 'onmousedown="DoSuperMouseDown( this, false, true)" >';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/md_left_blu.gif"></td>';
         htmlstr += '<td class="superButtons" style="BACKGROUND-IMAGE:url(../img/md_bkgrd_blu.gif);CURSOR:hand;">';
         if (hiddenid == "CreateFileListNoStatusAmend")
         {
            htmlstr += 'Amend Selected Return';
         }
         else
         {
            htmlstr += 'Extend Existing Return';
         }
         htmlstr += '</td>';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/mdicn_arrowblu_right.gif"></td>';
         htmlstr += '<td><img style="vertical-align:bottom;" src="../img/md_right_blu.gif"></td>';
         htmlstr += '</tr></table>';
         htmlstr += '</span>';
         setFocusItemID("FocusExistingID");
      }
      
         
      htmlstr += '</div></td></tr></table>';
         
      htmlstr += '</div>';
      htmlstr += '<div class="normalTopPadding" style="text-align: right;">';
      if (hiddenid == "CreateFileListNoStatusAmend")
      {     
         htmlstr += '<span class="ds_stylemain" id="AmendBrowseBtn"/><span tabIndex = "3" onclick="generateClick(';
         htmlstr += "'AmendBrowseBtn')";
      }
      else
      {
         htmlstr += '<span class="ds_stylemain" id="ExtendBrowseBtn"/><span tabIndex = "3" onclick="generateClick(';
         htmlstr += "'ExtendBrowseBtn')";
      }
      htmlstr += '" onkeyup="preInterview_accelarator(this)"';
      htmlstr += 'style="text-decoration: underline; COLOR: #3300ff;CURSOR: hand; FONT-SIZE: 14px"><br>';
      htmlstr += 'Browse to find file</span><br/><br/>';
      htmlstr += '</div>';

   }
   catch(htmlstr){};
   return htmlstr;
}

// create the list of existing returns, with status displayed
function createListEntryWithStatus(idNum, fullname, displayname, gif, status, date, setDefault) 
{
   try
   {
      // if status = Check e-File Status Now then make it a link
      var bStatusLink;
      var pattern = /Check e-File Status Now/;
      if (pattern.exec(status))
         bStatusLink = "1";
      else
         bStatusLink = "0";
         
      var s = '<div style="width: 100% "';
      if (gbFilesFound == "1") // don't show radio button if there are no files found
      {
         s += '; onclick="';
         s += "selrow('"+idNum+"')";
         s += '" ondblclick="';
         s += "OnContinueReturn(selName,'ExistingBtn')";
         s += '" fullname="'+fullname;
         s += '" id="'+idNum+'"> <label for="';
         s += idNum + 'RAdIO">';
         s += '<span style="HEIGHT: 20px;WIDTH: 20px;"><input type="radio" style="vertical-align: top" name="FileList" tabIndex="5" ';
         if (setDefault == "1")
         {
         s += 'checked="1"';
         }     
         s += 'id="'+idNum+'RADIO"';
         s += '/></span>';
      }
         
      s += '<span style="HEIGHT: 20px; WIDTH: 240px; CURSOR: default;vertical-align: top">' + displayname + '</span>';
      if (gif != '')
         s += '<span style="HEIGHT: 20px;WIDTH:20px;CURSOR: default;vertical-align: top"><img src=' + gif + '></span>';
      else
         s += '<span style="HEIGHT: 20px;WIDTH:20px;vertical-align: top"></span>';
      
      if (bStatusLink == "1")
      {
         s += '<span style="HEIGHT: 20px;WIDTH: 200px; CURSOR: hand; text-decoration: underline; COLOR: blue; vertical-align: top"';
         s += ' onclick="';
         s += "selrow('"+idNum+"');";
         s += "OnContinueReturn(selName,'ExistingBtn');";
         s += '">';
         s += status + '</span>';
      }
      else
         s += '<span style="HEIGHT: 20px;WIDTH: 200px; CURSOR: default;vertical-align: top">' + status + '</span>';
      
      s += '<span style="HEIGHT: 20px;WIDTH: 75px; CURSOR: default;vertical-align: top">' + date + '</span>';
      
      if (gbFilesFound == "1") // label is open for the the radio buttons
         s += '</label>';
         
      s += '</div>';

      if (setDefault == "1")
      {
         gDefaultID = idNum;
         gDefaultFilename = fullname;
      }
      return s;
   }
   catch(s){}
}

// create the list of existing returns, with no status displayed - for amended and extended return screens
function createListEntryNoStatus(idNum, fullname, displayname, date, setDefault) 
{
   try
   {
      var s = '<div style="width: 100%"';
      if (gbFilesFound == "1") // don't show radio button if there are no files found
      {
         s += ' onclick="';
         s += "selrow('"+idNum+"')";
         s += '" ondblclick="';
         s += "OnContinueReturn(selName,'ExistingBtn')";
         s += '" fullname="'+fullname;
         s += '" id="'+idNum+'"> <label for="';
         s += idNum + 'RADIO">';
         s += '<span style="HEIGHT: 20px;WIDTH: 20px;"><input type="radio" style="vertical-align: top" name="FileList" tabIndex="1" ';
         if (setDefault == "1")
         {
            s += 'checked="1"';
         }     
         s += 'id="'+idNum+'RADIO"';
         s += '/></span>';
      }
      s += '<span style="HEIGHT: 20px;WIDTH: 440px; CURSOR: default;vertical-align: top">' + displayname + '</span>';
      s += '<span style="HEIGHT: 20px;WIDTH: 100px; CURSOR: default;vertical-align: top">' + date + '</span>';
      if (gbFilesFound == "1") // label is open for the radio button
         s += '</label>';
      s += '</div>';
      if (setDefault == "1")
      {
         gDefaultID = idNum;
         gDefaultFilename = fullname;
      }
      return s;
   }
   catch(s){}
}

// pass clicks on to CPP code
function generateClick( id )
{
   try
   {
      var e = document.getElementById (id);
      if (e)
      {
         e.fireEvent("onclick");
      }
   }
   catch (e) {}
}

// stuff str into title and call oncontinue return method
function OnContinueReturn(strFilename,btnID)
{
   try
   {
      var elem = document.getElementById(btnID);
      if (elem)
      {
         elem.title = strFilename;
         elem.fireEvent("onclick");
      }
   }
   catch(elem){}
}

// display the Amend screen
function JumpToAmend( )
{
   var elem = document.getElementById("AmendBtn");
   if (elem)
   {
      try
      {
         elem.fireEvent("onclick");
      }
      catch(exc) {}
   }
   //window.open("../dlg/preInterviewAmend.htm","_self","","false");
}
// display the Extend screen
function JumpToExtend( )
{
   window.open("../dlg/preInterviewExtend.htm","_self","","false");
}
// display the Tour - supplied by bmedia...expect in the local\tour directory
function DisplayOverview( )
{
   try
   {
      if (gOverviewWindow)
      {
         try
         {
            if (gOverviewWindow.closed)
            {
               gOverviewWindow = null;
            }
            else
            {               
               gOverviewWindow.focus();             
            }
         }
         catch(exc)
         {
            gOverviewWindow = null;
         }
      }

      if (gOverviewWindow == null) {
         gOverviewWindow=window.open("../tour/Welcome.htm","Overview","","false");
      }
   }
   catch (exc) {}
}
function BackToWelcome( )
{
   window.open("../dlg/preInterviewWelcome.htm","_self","","false");
}

//-----------------------------------------------------------------------------
function preInterview_accelarator( e )
   // Invoke the click event if space or enter key is pressed
{
   if( !e ) return;
   
   var evt = window.event;
   if( !evt ) return;
   if( 13 == evt.keyCode || 32 == evt.keyCode )
   {
      e.fireEvent("onclick");
   }
}  

//-----------------------------------------------------------------------------
function setFocusItemID(id)
{
   try
   {
      currentFocusItem = id;
      return "";
   } catch (exc) {}
}

focusTimer = null;

//-----------------------------------------------------------------------------
function setFocusItem()
{
   try
   {
      clearTimeout(focusTimer);

      if (!currentFocusItem) return;
      
        var e = document.getElementById( currentFocusItem );
      if(e)
      {
         try
         {
            e.focus();
         }
         catch(e){}  
      }  
   } catch (exc) {}
}

//-----------------------------------------------------------------------------
function setFocus()
{
   try
   {
      focusTimer = setTimeout("setFocusItem()",250);
   } catch (exc) {}
}


//-----------------------------------------------------------------------------
function insert1stTimeFilerText()
{
    try
    {
        var elemIsPremier = document.getElementById("IsPremier");
        if (elemIsPremier)
        {
            elemIsPremier.fireEvent("onclick");

            var strHTML = "";
            if (elemIsPremier.title)
            {
                strHTML = "<span>Preparing a return for your child? Check out a <span onclick=\"window.open('http://www.turbotax.youngtaxfiler.com/pwp','_blank','','false')\" style=\"text-decoration: underline;COLOR: #3300ff; CURSOR: hand\" tabIndex=\"4\" onkeyup=\"preInterview_accelarator(this)\"><b>new site for 1st-time filers</b></span>.</span><br/>";
            }

            var elem = document.getElementById("1stTimeFilerText");
            if (elem)
            {
                elem.innerHTML = strHTML;
            }
        }
    }
    catch(elemIsPremier){};
}


function insertExtensionText(page)
{
   var strHTML;
   try
   {
      var hiddenelem = document.getElementById("IsBizProduct");
      var elem = document.getElementById("ExtensionText");
      if (hiddenelem)
      {
         hiddenelem.fireEvent("onclick");
         var bIsBiz = hiddenelem.title;
         if (page == "Welcome")
         {
            if (bIsBiz == "0") //not biz use date
            {
               strHTML = '<span class="ds_stylemain">if you can\'t finish your return by April 16, 2007.</span>';  // RTB:TYCO-NY
            }
            else //is biz don't use date
            {
               strHTML = '<span class="ds_stylemain">if you can\'t finish your return by the filing date.</span>';
            }
         }
         else // it's the extension page
         {
            if (bIsBiz == "0") //not biz use date
            {
               strHTML = '<div class="ds_stylemain normalBottomPadding">If you can\'t finish your tax return by April 16, 2007, '; // RTB:TYCO-NY
               strHTML += "we'll help you file an extension. <b>Choose one of the following options:</b></div>";
            }
            else //is biz don't use date
            {
               strHTML = '<div class="ds_stylemain normalBottomPadding">If you can\'t finish your tax return by the filing date, '
               strHTML += "we'll help you file an extension. <b>Choose one of the following options:</b></div>";
            }
         }
      }
   }
   catch(hiddenelem){};
   elem.innerHTML = strHTML;
}


//-------------------------------------- TT Biz ---------------------------------------
// call cpp code to get the data to populate the list box with
function fillFormsetListBox(hiddenid,listid)
{
	try
	{
		var hiddenelem = document.getElementById(hiddenid);
		var elem = document.getElementById(listid);
		if (hiddenelem && elem)
		{
			hiddenelem.fireEvent("onclick");
			var str = hiddenelem.title;
			var strHTML = '';

			str = eval(str);
			strHTML += str;

			elem.innerHTML = strHTML;
			selrow(gDefaultID);
		}
	}
	catch(hiddenelem){};
}


// create the list of formsets for user to select
function createFormsetList(idNum, fsid, displayname, description, helpid, setDefault) 
{  
   try
   {
 	  var s = '<div style="width: 100%"';
	  s += ' onclick="';
	  s += "selformset('"+idNum+"')";
	  s += '" fullname="'+fsid;
	  s += '" id="'+idNum+'"> <label for="';
	  s += idNum + 'RADIO">';
	  s += '<span style="HEIGHT: 20px;WIDTH: 20px;"><input type="radio" style="vertical-align: top" name="FileList" tabIndex="1" ';
	  if (setDefault == "1")
	  {
		 s += 'checked="1"';
	  }		
	  s += 'id="'+idNum+'RADIO"';
	  s += '/></span>';

	  s += '<span style="HEIGHT:20px; WIDTH:440px; CURSOR:default; vertical-align: top">' + displayname + '</span>';

	  s += '</label>';
	  s += '</div>';
        
      s += '<div>';
      s += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
      s += description; 
      s += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
      s += '<span class="ds_stylemain" tabIndex="7" style="CURSOR: hand; COLOR: blue; TEXT-DECORATION: underline" onclick=';
      //following aligns the More Info link, commented out for now
	  //s += '<span class="ds_stylemain" tabIndex="7" style="float:right; position:relative; bottom:1.3em; right:2cm; CURSOR: hand; COLOR: blue; TEXT-DECORATION: underline" onclick=';
      s += '"OnHelp(';
      s += '\'';
      s += helpid;
      s += '\',\'FSHelpBtn\')"/><b>More Info</b></SPAN>'; 
	  s += '<input type="hidden" id="FSHelpBtn"/>';
      s += '</div>'; 
      
      var i=0
      var ln=""
      var cnt=80   
            
	  for(i=0; i<cnt; i++)
	  {
         ln += "-";   
      }
      s += '<div class="note">';
      s += ln;
      s += '</div>';
      
	  if (setDefault == "1")
	  {
		 gDefaultID = idNum;
         gFsid = fsid;
      }
   }
   catch(s){}
   return s;    
}

function OnNewReturn()
{
	try
	{
		var elem = document.getElementById("NewReturnBtn");
		if (elem)
		{
			elem.title = gFsid;
			elem.fireEvent("onclick");
		}
	}
	catch(elem){}
}


function OnHelp(helpID,btnID)
{
	try
	{
		var elem = document.getElementById(btnID);
		if (elem)
		{
			elem.title = helpID;
			elem.fireEvent("onclick");
		}
	}
	catch(elem){}
}

function selformset(id)
{
	try
	{
		var element = document.getElementById( id );
		if (element)
		{
			selected = element;
            gFsid = element.fullname;
		}
	}
	catch (element) {}
}


function DoFormSetContinueButton(	containerId,
						buttonId,
						buttonText,
						tabIndex, 
						hasLeftArrow, 
						hasRightArrow, 
						isEnabled)
{
	var htmlstr = '';
	var tableDataEnabledStr = '<td class="superButtons" style="cursor:hand;">';
	var tableDataDisabledStr = '<td class="superButtons">';
	try
	{
		var containerElement = document.getElementById(containerId);
		if (!containerElement)
		{
			alert("Cannot find container element for button: " + buttonText);
			return;
		}
		
		htmlstr += MakeSuperButton2(	buttonId,
										buttonText,
										tabIndex, 
										hasLeftArrow, 
										hasRightArrow, 
										isEnabled);
		//alert(htmlstr);
		containerElement.innerHTML = htmlstr;
	}
	catch (htmlstr) { alert(htmlstr); };
}




function MakeSuperButton2(buttonId,
						buttonText,
						tabIndex, 
						hasLeftArrow, 
						hasRightArrow, 
						isEnabled)
{
	var htmlstr = '';
	var tableDataEnabledStr = '<td class="superButtons" style="cursor:hand;">';
	var tableDataDisabledStr = '<td class="superButtons">';
	try
	{
		htmlstr += '<table cellpadding=0px cellspacing=0px id="' + buttonId + 'Table"';


		if (isEnabled)
		{
            
			htmlstr += 'tabIndex="' + tabIndex + '" onclick="OnNewReturn()" ';
                 
			htmlstr += 'onkeyup="preInterview_accelarator(this)" ';
			htmlstr += 'onmousedown="DoSuperMouseClickGraphics( this, ' + hasLeftArrow + ',' + hasRightArrow + ')">';
		}
		else
			htmlstr += '>';
		htmlstr += '<tr style="margin:0px;padding:0px;border:none; vertical-align:middle">';
		// 
		// Do the left side of the button
		if (isEnabled)
			htmlstr += tableDataEnabledStr;
		else
			htmlstr += tableDataDisabledStr;
		htmlstr += '<img id="' + buttonId + '" style="vertical-align:bottom;"';
		if (isEnabled == false)
			htmlstr += ' src="../img/md_left_blu_dis.gif">';
		else
			htmlstr += ' src="../img/md_left_blu.gif">';
			
		htmlstr += '</td>';
		// If the button has a left arrow (like the Back button), do the left arrow
		if (hasLeftArrow)
		{
			if (isEnabled)
				htmlstr += tableDataEnabledStr;
			else
				htmlstr += tableDataDisabledStr;
			htmlstr += '<img style="vertical-align:bottom;"';
			if (isEnabled == false)
				htmlstr += ' src="../img/mdicn_arrowblu_left_dis.gif">';
			else
				htmlstr += ' src="../img/mdicn_arrowblu_left.gif">';
			htmlstr += '</td>';
		}

		
		// Do the center with the background and text.
		htmlstr += '<td class="superButtons" ';
		if (isEnabled)
		{
			htmlstr += 'style="background-image:url(../img/md_bkgrd_blu.gif);';
			htmlstr += ' cursor:hand;">';
		}
		else
			htmlstr += 'style="background-image:url(../img/md_bkgrd_blu_dis.gif);">';
			
		htmlstr += buttonText;	
		
		htmlstr += '</td>';
		
		// Do the Right arrow if there is one
		if (hasRightArrow)
		{
			if (isEnabled)
				htmlstr += tableDataEnabledStr;
			else
				htmlstr += tableDataDisabledStr;
			
			htmlstr += '<img style="vertical-align:bottom;"';
			if (isEnabled == false)
				htmlstr += ' src="../img/mdicn_arrowblu_right_dis.gif">';
			else
				htmlstr += ' src="../img/mdicn_arrowblu_right.gif">';
			htmlstr += '</td>';
		}
		
		// Do the right side.
		if (isEnabled)
			htmlstr += tableDataEnabledStr;
		else
			htmlstr += tableDataDisabledStr;
		
		htmlstr += '<img style="vertical-align:bottom"';
		if (isEnabled == false)
			htmlstr += ' src="../img/md_right_blu_dis.gif">';
		else
			htmlstr += ' src="../img/md_right_blu.gif">';
		
		htmlstr += '</td>';		

		htmlstr += '</tr></table>';
		
	}
	catch(htmlstr){ return htmlstr; };
	
	return htmlstr;
}
